#!/bin/ksh
. /usr/opt/etc/nwis.profile
. ${NWISHOME}/util/nwo_set_nwis_env

# Determine if user has access to do this
if [ ! `whoami` = 'nwis' ]
then
     echo ""
     echo "You are running as `whoami`. "
     echo "This script needs to be run as user nwis."
     echo "Therefore you can not run this script."
     echo
     echo "EXITING....."
     echo
     exit 1
fi

#
# Start
echo ' '
echo '********** NWIS 4.10 database set sensors to generic started at' `date`
echo '**********' Processing database ${NWISDB}

# Start a temp rdb file
echo 'db_no\tparm\tmeth\tmanufacturer\told_serial\tnew_serial' >| /tmp/$$.setGeneric.rdb
echo '5N\t5S\t5S\t20S\t15S\t8S' >> /tmp/$$.setGeneric.rdb

# Get a list of LOC_SENSOR_## tables in this ingres database
tbllst=`tsql ${NWISDB} -Gnwis_select "select table_name from iitables where table_type='T' and table_owner='nwis' and table_name like 'loc_sensor/_/[0-9/]/[0-9/] %' escape '/' order by table_name"`
for tbl in ${tbllst} ; do
    #
    # Extract the databse number suffix from the table name
    db_no=${tbl##loc_sensor_}
    
    # Build a temp table of old and new sensor ids (using loc to get site to get the ones 
    # with the site number as the serial number)
    query1="declare global temporary table session.generic_sensors_${db_no} as select distinct s.agency_cd,s.site_no,l.loc_nu,l.loc_id,st.parm_cd,st.meth_cd,n.sensor_ser_no, n.sensor_id as old_sensor_id,n2.sensor_ser_no as new_sensor_ser_no, n2.sensor_id as new_sensor_id,st2.sensor_mfg_nm from sitefile_${db_no} s, loc_${db_no} l, loc_sensor_${db_no} ls, sensor_${db_no} n, sensor_type st, sensor_${db_no} n2, (sensor_type st2 join parm p on p.parm_cd=st2.parm_cd) where l.site_id=s.site_id and ls.loc_id=l.loc_id and n.sensor_id=ls.sensor_id and st.sensor_type_id=n.sensor_type_id and n.sensor_ser_no=s.site_no and st2.parm_cd=st.parm_cd and st2.meth_cd=st.meth_cd and n2.sensor_type_id=st2.sensor_type_id and st2.sensor_mfg_nm=st.sensor_mfg_nm and n2.sensor_ser_no='generic' on commit preserve rows with norecovery"
   
    # Build a temp table of existing loc_sensor keys that appear in the previous temp table
    query2="declare global temporary table session.dups_${db_no} as select loc_id, sensor_id from loc_sensor_${db_no} where varchar(loc_id)+varchar(sensor_id) in (select varchar(loc_id)+varchar(new_sensor_id) from session.generic_sensors_${db_no}) on commit preserve rows with norecovery"

    # Display the changes to be made */
    query3="select distinct '${db_no}',parm_cd,meth_cd,sensor_mfg_nm,sensor_ser_no,new_sensor_ser_no from session.generic_sensors_${db_no} where varchar(loc_id)+varchar(new_sensor_id) not in (select varchar(loc_id)+varchar(sensor_id) from session.dups_${db_no}) order by parm_cd,meth_cd,sensor_mfg_nm,sensor_ser_no"
    
    tsql $NWISDB -Gnwis_select "${query1}" "${query2}" "${query3}" >> /tmp/$$.setGeneric.rdb
done

echo 'Sensors to be changed:'
ptbl -l132 -p0 < /tmp/$$.setGeneric.rdb

rm /tmp/$$.setGeneric.rdb

echo 
echo 'Ok to proceed? (Y/N):\c'
read answer
if [ ! ${answer} = "Y" ] && [ ! ${answer} = "y" ] ; then 
    echo
    echo 'Aborted by user'
    exit 1
fi

# Start an SQL commands file 
echo "" >| /tmp/$$.setGeneric.sql

# Get a list of LOC_SENSOR_## tables in this ingres database
tbllst=`tsql ${NWISDB} -Gnwis_select "select table_name from iitables where table_type='T' and table_owner='nwis' and table_name like 'loc_sensor/_/[0-9/]/[0-9/] %' escape '/' order by table_name"`
for tbl in ${tbllst} ; do
    #
    # Extract the databse number suffix from the table name
    db_no=${tbl##loc_sensor_}

    echo ' '
    echo '********** Processing for database number '${db_no} started at `date`

    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* Build a temp table of old and new sensor ids */" >> /tmp/$$.setGeneric.sql
    echo "declare global temporary table session.generic_sensors_${db_no} as" >> /tmp/$$.setGeneric.sql
    echo "select distinct s.agency_cd,s.site_no,l.loc_nu,l.loc_id,st.parm_cd,st.meth_cd,n.sensor_ser_no," >> /tmp/$$.setGeneric.sql
    echo "	n.sensor_id as old_sensor_id,n2.sensor_ser_no as new_sensor_ser_no," >> /tmp/$$.setGeneric.sql
    echo "	n2.sensor_id as new_sensor_id,st2.sensor_mfg_nm" >> /tmp/$$.setGeneric.sql
    echo "from sitefile_${db_no} s, loc_${db_no} l, loc_sensor_${db_no} ls, sensor_${db_no} n, sensor_type st," >> /tmp/$$.setGeneric.sql
    echo "	sensor_${db_no} n2, (sensor_type st2 join parm p on p.parm_cd=st2.parm_cd)" >> /tmp/$$.setGeneric.sql
    echo "where l.site_id=s.site_id and ls.loc_id=l.loc_id and " >> /tmp/$$.setGeneric.sql
    echo "	n.sensor_id=ls.sensor_id and st.sensor_type_id=n.sensor_type_id and" >> /tmp/$$.setGeneric.sql
    echo "	n.sensor_ser_no=s.site_no and st2.parm_cd=st.parm_cd and " >> /tmp/$$.setGeneric.sql
    echo "	st2.meth_cd=st.meth_cd and n2.sensor_type_id=st2.sensor_type_id and" >> /tmp/$$.setGeneric.sql
    echo "	st2.sensor_mfg_nm=st.sensor_mfg_nm and n2.sensor_ser_no='generic'" >> /tmp/$$.setGeneric.sql
    echo "on commit preserve rows" >> /tmp/$$.setGeneric.sql
    echo "with norecovery;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* delete any sensors that already appear in the loc_sensor table and would cause a duplicate key error */" >> /tmp/$$.setGeneric.sql
    echo "delete from session.generic_sensors_${db_no} " >> /tmp/$$.setGeneric.sql
    echo "where varchar(loc_id)+varchar(new_sensor_id) in" >> /tmp/$$.setGeneric.sql
    echo "	(select varchar(loc_id)+varchar(sensor_id) " >> /tmp/$$.setGeneric.sql
    echo "	from loc_sensor_${db_no} " >> /tmp/$$.setGeneric.sql
    echo "	where varchar(loc_id)+varchar(sensor_id) in " >> /tmp/$$.setGeneric.sql
    echo "		(select varchar(loc_id)+varchar(new_sensor_id) " >> /tmp/$$.setGeneric.sql
    echo "		from session.generic_sensors_${db_no})" >> /tmp/$$.setGeneric.sql
    echo "	);" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* Display the changes to be made based on loc_sensors (we used loc to get the site number) */" >> /tmp/$$.setGeneric.sql
    echo "select agency_cd,site_no,loc_nu,parm_cd,meth_cd,sensor_mfg_nm,sensor_ser_no,new_sensor_ser_no" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no}" >> /tmp/$$.setGeneric.sql
    echo "order by agency_cd,site_no,loc_nu,parm_cd,meth_cd,sensor_mfg_nm,sensor_ser_no;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* Display the sensor changes to be made */" >> /tmp/$$.setGeneric.sql
    echo "select old_sensor_id,sensor_ser_no,new_sensor_id,new_sensor_ser_no" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no}" >> /tmp/$$.setGeneric.sql
    echo "order by sensor_ser_no,old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* change the sensor ids in the loc_sensor table */" >> /tmp/$$.setGeneric.sql
    echo "update loc_sensor_${db_no} ls" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where ls.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* change the sensor ids in the qwmon_insp child tables table */" >> /tmp/$$.setGeneric.sql
    echo "update eqp_sensor_${db_no} es" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where es.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update drft_chk_cond_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update drft_chk_do_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update drft_chk_ph_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update drft_chk_trb_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update drft_chk_wtrtmp_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "update qwmon_chk_rdng_${db_no} dc" >> /tmp/$$.setGeneric.sql
    echo "from session.generic_sensors_${db_no} gs" >> /tmp/$$.setGeneric.sql
    echo "set sensor_id=gs.new_sensor_id" >> /tmp/$$.setGeneric.sql
    echo "where dc.sensor_id=gs.old_sensor_id;" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
    echo "" >> /tmp/$$.setGeneric.sql
    echo "/* delete the old sensors with the site number serial numnbers */" >> /tmp/$$.setGeneric.sql
    echo "delete from sensor_${db_no} where sensor_id in" >> /tmp/$$.setGeneric.sql
    echo "(select old_sensor_id from session.generic_sensors_${db_no});" >> /tmp/$$.setGeneric.sql
    echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
done

#
# finish the SQL commands file
echo "" >> /tmp/$$.setGeneric.sql
echo "commit;" >> /tmp/$$.setGeneric.sql
echo '\\time\p\g' >> /tmp/$$.setGeneric.sql
echo "" >> /tmp/$$.setGeneric.sql
echo '\q' >> /tmp/$$.setGeneric.sql

# run the SQL
sql $NWISDB < /tmp/$$.setGeneric.sql

# cleanup
rm /tmp/$$.setGeneric.sql

#
# finish
echo ' '
echo '********** NWIS 4.10 database set sensors to generic finished at' `date`
