#!/usr/bin/perl

use strict;
my (@dirs,$dir,@lines,$cwd,$cmnd,$cnt,$tmpStr);
my ($theSubDir, $theLogDir, $theOrigFileDir, $theQueueDir, 
    $theExpectDir, $sumRptDir, $nwisDB, $theDBNum, $applyGHC, 
    $applyShiftC, $peakDef, $theGo2Dir, $siteSpecData, 
    $testMode, $sumOnly, $optOnly, $maxShift, $nwisWebDD,
    $rst,$sumRptDir,$emailList,$theNwisFile,$exemptFile,
    $useGo2,$includeFile,$sh,$lookBack,$statusNumLines,
    $theQuarantineDir, $smartSupport,$maxLogAgeDays,$smartHome);

# get the current directory
open (INPUT,"pwd |");
while (<INPUT>) {
  chop;
  $cwd = $_;
}
close (INPUT);

print "\n\nSMART's home is $cwd\n\n";

($theSubDir, $theLogDir, $theOrigFileDir, $theQueueDir, 
 $theExpectDir,$nwisDB, $theDBNum, $applyGHC, 
 $applyShiftC, $peakDef, $theNwisFile,$theGo2Dir, 
 $siteSpecData, $testMode, $sumOnly, $optOnly, 
 $maxShift, $emailList,$sumRptDir,$exemptFile,
 $includeFile, $useGo2, $smartHome,$lookBack,
 $statusNumLines,$theQuarantineDir,$smartSupport,
 $maxLogAgeDays) = &readCntrlFile;

# Check to see if the needed directories, exists, if they do 
# not create them.
($rst) = &checkDir ($theSubDir);
($rst) = &checkDir ($theLogDir);
($rst) = &checkDir ($theOrigFileDir);
($rst) = &checkDir ($theQueueDir);
($rst) = &checkDir ($theExpectDir);
($rst) = &checkDir ($sumRptDir);
($rst) = &checkDir ($theQuarantineDir);

if (&ck4FileItem($theGo2Dir,"folder") == 1) {
  print "The GO2 direcotry $theGo2Dir exists\n";
} else {
  print "The GO2 directory $theGo2Dir does NOT exists.\n";
}
if (&ck4FileItem($siteSpecData,"file") == 1) {
  print "The site specific data file $siteSpecData exists\n";
} else {
  print "The site specific data file $siteSpecData does NOT exists.\n";
}
if (&ck4FileItem($nwisWebDD,"file") == 1) {
  print "The NWIS Web DD file $nwisWebDD exists\n";
} else {
  print "The NWIS Web DD file $nwisWebDD does NOT exists.\n";
}
if (&ck4FileItem($exemptFile,"file") == 1) {
  print "The file $exemptFile containing the list of site to not process exists.\n";
} else {
  print "The file $exemptFile containing the list of site to not process does NoTexists.\n";
}
if (&ck4FileItem($includeFile,"file") == 1) {
  print "The file $includeFile containing the list of site to process exists.\n";
} else {
  print "The file $includeFile containing the list of site to process does NOT exists.\n";
}

# Unpack the software
$cmnd = "tar -xvf smartCode.tar";
system ($cmnd);

# remove the software tar
#unlink ("smartCode.tar");

$sh = $cwd. "/getblob.sh";
open (OUTPUT,">$sh");
print OUTPUT "#!/usr/bin/csh\n";
print OUTPUT "setenv II_SYSTEM /usr/opt\n";
$tmpStr = "cd " . $cwd;
print OUTPUT "$tmpStr\n";
$tmpStr = $cwd . "/getBlob.pl";
print OUTPUT "$tmpStr\n";
close (OUTPUT);

$cmnd = "chmod 755 getblob.sh getBlob.pl clsmart.pl";
system ("$cmnd");

$cmnd = "chmod 755 thesubroutines/*";
system($cmnd);

die "SMART software installed.";

# **************************************************
# **************************************************
# **
# ** sub ck4FileItem
# **
# ** Check to see if the file or folder exists
# ** This subroutine checks to see if a file system 
# ** object exists.  The application is limited to 
# ** directories/folders and files.  The application is
# ** passed the object's name and the type of ojbect,
# ** folder or file.  If the object exists the return 
# ** value is set to zero.  If the  object does not 
# ** exists the return value is set to one.
# **
# ** Variables
# ** $item -- Name of the file or directory being tested
# ** $desc -- Is the item a file or directory
# ** $rtnVal -- Returned to the calling program, 
# **    0 if the file or directory exists, 
# **    1 if it does not exists.
# ** 
# **************************************************
# *************************************************

sub ck4FileItem {
# Make all variables local and get the information 
# passed by the calling program (@_).
  use strict;
  my ($item,$desc) = @_;
  my ($rtnVal);

  $rtnVal = 0;

# Test to see if the folder exists
  if ($desc =~ /folder/) {

# Does the item with the name in $item exists
    if (-e $item) {

# Is the item a directory
      if (-d $item) {

# Yes, set the return value to one.
        $rtnVal = 1;
      } else {

# No, set the return value to zero 
        $rtnVal = 0;
      }
    } else {
# Object does not exists return zero
      $rtnVal = 0
    }

# The item is a file, does it exist
  } elsif ($desc =~ /file/) {

# File exist return 1
    if (-e $item) {
      $rtnVal = 1;
      
# File does not exist return 0
    } else {
      $rtnVal = 0;
    }
  }
  return ($rtnVal);
}


# **************************************************
# **************************************************
# **
# ** Subroutine readCntrlFile
# **
# ** Reads the SMART control file and returns the
# ** values contained in the file.
# **
# **************************************************
# **************************************************
sub readCntrlFile {
  use strict;
  my ($lDir, $cntrlFile, @theParts, $theSubDir, $theLogDir, 
      $theOrigFileDir, $theQueueDir, $theExpectDir,$nwisDB, 
      $theDBNum, $applyGHC, $applyShiftC, $peakDef, $theNwisFile,
      $theGo2Dir, $siteSpecData, $testMode, $sumOnly, $optOnly, 
      $maxShift, $emailList,$cnt,$smartHome,$exemptFile,$useGo2,
      $lookBack,$statusNumLines,$smartQuarantineDir, $maxLogAgeDays,
      $smartSupport,$theRptTemplate);

# Set the name of the directory where the driver code and 
# control file are stored.
  open (INPUT, "pwd |");
  while (<INPUT>) {
    chop;
    $_ =~ s/^\s+//;
    $_ =~ s/\s_$//;
    if (length($_) > 0) {
      $lDir = $_;
      last;
    } else {
      die "Can not identify the current working direcotry";
    }
  }
  close(INPUT);
  
  @theParts = split(/\//,$lDir);
  $cnt = 1;
  $lDir = "";
  until ($cnt > $#theParts) {
    $lDir = $lDir . "/" . $theParts[$cnt];
    $cnt = $cnt + 1;
  }

# Read the control file to get information needed to run SMART
  $cntrlFile = $lDir . "/smartCntrl";
  open (INPUT,"<$cntrlFile");
  while (<INPUT>) {
    chop;     # Removes the last character from the line
    $_ =~ s/\xOD//g;   #Strips all control M's from the line

# Number of minutes between getBlob runs.  Must match the
# number of minutes in the cron file
  if ($_ =~ /^minbetweenrun/i) {
    @theParts = split(/: /,$_,2);
    $theParts[1] =~ s/^\s+//;
    $theParts[1] =~ s/\s+$//;
    $lookBack = $theParts[1];
  }

# Number of messages to be maintained in the status log
  if ($_ =~ /^statuslines/i) {
    @theParts = split(/: /,$_,2);
    $theParts[1] =~ s/^\s+//;
    $theParts[1] =~ s/\s+$//;
    $statusNumLines = $theParts[1];
  }

# SMART HOME directory
    if ($_ =~ /^smarthome/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $smartHome = $theParts[1];
    }

# Directory containing the subroutines needed to run SMART
    if ($_ =~ /^smartsubs/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theSubDir = $theParts[1];
    }

# Directory where the SMART logs are stored
    if ($_ =~ /^smartlogs/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theLogDir = $theParts[1];
    }

# Directory where the original files are temporarily written
    if ($_ =~ /^smartorigfiles/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theOrigFileDir = $theParts[1];
    }

# Report directory and template
    if ($_ =~ /^smartrpttem/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theRptTemplate = $theParts[1];
    }

# Directory where the queues are temporarily written
    if ($_ =~ /^smartqueues/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theQueueDir = $theParts[1];
    }

# Directory where the EXPECT scripts are temporarily written
    if ($_ =~ /^expectdir/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theExpectDir = $theParts[1];
    }

# NWIS web file, last place to look to define DDs
    if ($_ =~ /^nwisweb/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theNwisFile = $theParts[1];
    }

# GO2 directory, used to limit e-mail summary reports
    if ($_ =~ /^go2dir/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theGo2Dir = $theParts[1];
    }

# Site specific data file
    if ($_ =~ /^sitespecific/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $siteSpecData = $theParts[1];
    }

# NWIS Database name
    if ($_ =~ /^nwisdb/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $nwisDB = $theParts[1];
    }
    
# NWIS Database number
    if ($_ =~ /^dbnum/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $theDBNum = $theParts[1];
    }

# Peak definition 
    if ($_ =~ /^peakdef/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $peakDef = $theParts[1];
    }

# Maximum shift 
    if ($_ =~ /^maxshift/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $maxShift = $theParts[1];
    }

# User to receive e-mail 
    if ($_ =~ /^notusers/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $emailList = $theParts[1];
    }

# Test Mode 
    if ($_ =~ /^testmode/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $testMode = $theParts[1];
    }

# Exempt site file
    if ($_ =~ /^exempt/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $exemptFile = $theParts[1];
    }

# Include site file
    if ($_ =~ /^include/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $includeFile = $theParts[1];
    }

# Use the Go2 filters to add to the e-mail list
    if ($_ =~ /^usego2/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $useGo2 = $theParts[1];
    }

# Apply gage height corrections
    if ($_ =~ /^applyghcor/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $applyGHC = $theParts[1];
    }

# Apply shift correction flag
    if ($_ =~ /^applyshiftcor/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $applyShiftC = $theParts[1];
    }

# SMART quarantine directory
    if ($_ =~ /^smartquarantine/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $smartQuarantineDir = $theParts[1];
    }

# Maximum age of SMART logs
    if ($_ =~ /^maxlogage/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $maxLogAgeDays = $theParts[1];
    }

# SMART support staff, individuals who get e-mail when
# file is moved to the quarantine directory.
    if ($_ =~ /^smartSupport/i) {
      @theParts = split(/: /,$_,2);
      $theParts[1] =~ s/^\s+//;
      $theParts[1] =~ s/\s+$//;
      $smartSupport = $theParts[1];
    }
  }   
# Closes while (<INPUT>)
  close (INPUT);
# Make sure the directory names are fully qualified
  if ($smartHome !~ /\/$/)  {
    $smartHome = $smartHome . "/";
  }
  if (substr($theSubDir,0,1) ne "/") {
    $theSubDir = $smartHome .  $theSubDir;
  }
  if (substr($theLogDir,0,1) ne "/") {
    $theLogDir = $smartHome .  $theLogDir;
  }
  if (substr($theOrigFileDir,0,1) ne "/")  {
    $theOrigFileDir = $smartHome . $theOrigFileDir;
  }
  if (substr($theQueueDir,0,1) ne "/")  {
    $theQueueDir = $smartHome . $theQueueDir;
  }
  if (substr($theExpectDir,0,1) ne "/")  {
    $theExpectDir = $smartHome . $theExpectDir;
  }
  if (substr($siteSpecData,0,1) ne "/") {
    $siteSpecData = $smartHome . $siteSpecData;
  }
  if (substr($theRptTemplate,0,1) ne "/")  {
    $theRptTemplate = $smartHome .  $theRptTemplate
  }
  if (substr($exemptFile,0,1) ne "/")  {
    $exemptFile = $smartHome . $exemptFile;
  }
  if (substr($includeFile,0,1) ne "/") {
    $includeFile = $smartHome . $includeFile;
  }
  if (substr($smartQuarantineDir,0,1) ne "/")  {
    $smartQuarantineDir = $smartHome .  $smartQuarantineDir
  }

# The following are default value for SMART
# when executed by getBlog and are used
# unless over ridden by site specific data.
#  $applyShiftC = "y";
#  $applyGHC = "y";
#  $sumOnly = "n";
  $optOnly = "n";
  return ( $theSubDir, $theLogDir, $theOrigFileDir, $theQueueDir, 
	   $theExpectDir,$nwisDB, $theDBNum, $applyGHC, 
	   $applyShiftC, $peakDef, $theNwisFile,$theGo2Dir, 
	   $siteSpecData, $testMode, $sumOnly, $optOnly, 
	   $maxShift, $emailList,$theRptTemplate,$exemptFile,
	   $includeFile, $useGo2, $smartHome,$lookBack,
	   $statusNumLines,$smartQuarantineDir,$smartSupport,
	   $maxLogAgeDays);
}
  


  

sub checkDir {
  use strict;
  my ($dir) = @_;
  my (@theParts,$cnt,$adir,$rtn);
  if (&ck4FileItem($dir,"folder") == 1) {
    print "$dir exists\n";
  } else {
    $dir =~ s/\\/\//g;
    print "$dir\n";
    @theParts = split(/\//,$dir);
    $cnt = 0;
    $adir = "";
    until ($cnt > $#theParts) {
      if (length($theParts[$cnt]) > 0) {
	$adir = $adir . "/" . $theParts[$cnt];
	if (&ck4FileItem($adir,"folder") < 1) {
	  print "Creating directory $adir " . &ck4FileItem($adir,"folder") . "\n";
	  mkdir($adir,0755);
	}
      }
      $cnt = $cnt + 1;
    }
    print 
  }
  if (&ck4FileItem($dir,"folder") == 0)  {die "Could not find the directory $dir"};
  return ($rtn);
}
